(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7893,        244]*)
(*NotebookOutlinePosition[      8738,        271]*)
(*  CellTagsIndexPosition[      8694,        267]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ \[Lambda] = \(-1\), \ h = 1/5, \ 1/10, \ 
      1/20\ *) \[IndentingNewLine] (*\ 
      Use\ formula\ \((2.2  .10)\)\ *) \[IndentingNewLine]\(\[Lambda] = \
\(-1.0\);\)\), "\[IndentingNewLine]", 
    \(\(a = 1.  + \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(b = 1.  - \[Lambda]\ h/2;\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma] = a/b;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ 2*Exp[x] - 1;\)\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/5;\)\), "\[IndentingNewLine]", 
    \(phitil[
        h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/b\)}], "Input"],

Cell[BoxData[
    \(1.3832248939710632`\)], "Output"],

Cell[BoxData[
    \(1.8434030737404763`\)], "Output"],

Cell[BoxData[
    \(2.397957270629699`\)], "Output"],

Cell[BoxData[
    \(3.0681488732369515`\)], "Output"],

Cell[BoxData[
    \(3.8799287330138355`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/10;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.3268136227681462`\)], "Output"],

Cell[BoxData[
    \(1.7159515251765782`\)], "Output"],

Cell[BoxData[
    \(2.1821674450456046`\)], "Output"],

Cell[BoxData[
    \(2.7433907429839364`\)], "Output"],

Cell[BoxData[
    \(3.42143814559347`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[h];\)\), "\[IndentingNewLine]", 
    \(\(h = 1/20;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          h] = \[Gamma]*phitil[0] + \((f[h] - f[0])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          2  h] = \[Gamma]*phitil[h] + \((f[2\ h] - f[h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          3\ h] = \[Gamma]*phitil[2\ h] + \((f[3\ h] - f[2\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \[Gamma]*phitil[3\ h] + \((f[4\ h] - \ f[3\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          5\ h] = \[Gamma]*phitil[4\ h] + \((f[5\ h] - f[4\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          6\ h] = \[Gamma]*phitil[5\ h] + \((f[6\ h] - f[5\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          7\ h] = \[Gamma]*phitil[6\ h] + \((f[7\ h] - f[6\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        8\ h] = \[Gamma]*phitil[7\ h] + \((f[8\ h] - f[7\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          9\ h] = \[Gamma]*phitil[8\ h] + \((f[9\ h] - f[8\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          10\ h] = \[Gamma]*phitil[9\ h] + \((f[10\ h] - f[9\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          11\ h] = \[Gamma]*phitil[10\ h] + \((f[11\ h] - f[10\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        12\ h] = \[Gamma]*phitil[11\ h] + \((f[12\ h] - f[11\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          13\ h] = \[Gamma]*phitil[12\ h] + \((f[13\ h] - f[12\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          14\ h] = \[Gamma]*phitil[13\ h] + \((f[14\ h] - f[13\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          15\ h] = \[Gamma]*phitil[14\ h] + \((f[15\ h] - f[14\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        16\ h] = \[Gamma]*phitil[15\ h] + \((f[16\ h] - f[15\ h])\)/
          b\), "\[IndentingNewLine]", 
    \(\(phitil[
          17\ h] = \[Gamma]*phitil[16\ h] + \((f[17\ h] - f[16\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          18\ h] = \[Gamma]*phitil[17\ h] + \((f[18\ h] - f[17\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(\(phitil[
          19\ h] = \[Gamma]*phitil[18\ h] + \((f[19\ h] - f[18\ h])\)/
            b;\)\), "\[IndentingNewLine]", 
    \(phitil[
        20\ h] = \[Gamma]*phitil[19\ h] + \((f[20\ h] - f[19\ h])\)/
          b\)}], "Input"],

Cell[BoxData[
    \(1.2213608157214373`\)], "Output"],

Cell[BoxData[
    \(1.4917391308977914`\)], "Output"],

Cell[BoxData[
    \(1.821986176420241`\)], "Output"],

Cell[BoxData[
    \(2.2253559255891746`\)], "Output"],

Cell[BoxData[
    \(2.7180370225920543`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{118, Automatic}, {37, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 498, 9, 139, "Input"],
Cell[2240, 62, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2312, 68, 610, 15, 107, "Input"],
Cell[2925, 85, 53, 1, 26, "Output"],
Cell[2981, 88, 53, 1, 26, "Output"],
Cell[3037, 91, 52, 1, 26, "Output"],
Cell[3092, 94, 53, 1, 26, "Output"],
Cell[3148, 97, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3238, 103, 1306, 32, 203, "Input"],
Cell[4547, 137, 53, 1, 26, "Output"],
Cell[4603, 140, 53, 1, 26, "Output"],
Cell[4659, 143, 53, 1, 26, "Output"],
Cell[4715, 146, 53, 1, 26, "Output"],
Cell[4771, 149, 51, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4859, 155, 2616, 62, 363, "Input"],
Cell[7478, 219, 53, 1, 26, "Output"],
Cell[7534, 222, 53, 1, 26, "Output"],
Cell[7590, 225, 52, 1, 26, "Output"],
Cell[7645, 228, 53, 1, 26, "Output"],
Cell[7701, 231, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7791, 237, 41, 1, 27, "Input"],
Cell[7835, 240, 42, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

